CREATE PROCEDURE usp_Insert_Patients_Global_Impression_of_Change_scale
AS
BEGIN


BEGIN
INSERT INTO [V5_Registry].[dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('PGIC', 'Patients Global Impression of Change (PGIC) scale', 'Patients Global Impression of Change (PGIC) scale', 'Initial', 'Initial', GETDATE(), GETDATE())
END

BEGIN
declare @type     int;


SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
FROM STD_SURVEY_TYPE
WHERE CODE = 'PGIC')

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, 'D', 'Date:', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'Chief Complaint:', 2, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2', 'Since beginning treatment at this clinic, how would you describe the change(if any)in ACTIVITY LIMITATIONS, 
            SYMPTOMS, EMOTIONS, and OVERALL QUALITY OF LIFE, rated to your painful condition? (Tick ONE box)', 3, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3', 'In a similar way, please cicle the number below, that matches your degree of change since
            beginning care at this cinic ', 4, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

END
 
BEGIN

declare @question     int, 
        @maxchoice    int,
        @choice       int;
        
--------Question 1  
 
SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'PGIC' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 2)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Chief Complaint:' ,'Chief Complaint:', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
           
--------Question 2

SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'PGIC' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 3)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'No change (or condition has gotton worse)', 'No change (or condition has gotton worse)    1',
            1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Almost the same, hardly any change at all', 'Almost the same, hardly any change at all    2',
            2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---3
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'A little better, but no noticeable change', 'A little better, but no noticeable change    3',
            3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---4
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Somewhat better, but the change has not made a real difference',
            'Somewhat better, but the change has not made a real difference    4', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
SET @maxchoice = (SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE])
---5
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Modertely better, and a slight but noticeable change', 'Modertely better, and a slight but noticeable change    5',
            5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---6
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Better and a definite improvement that has made a wrothwhile improvement',
            'Better and a definite improvement that has made a wrothwhile improvement    6', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
---7
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
    ( @choice, @question, 'A great deal better, and a considerable improvement that has made all the difference',
     'A great deal better, and a considerable improvement that has made all the difference    7', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
--------Question 3  
 
SELECT @question=  (SELECT q.ID  
FROM STD_QUESTION q
    ,STD_SURVEY_TYPE t
WHERE CODE = 'PGIC' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 4)
----1
SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [V5_Registry].[dbo].[STD_QUESTION_CHOICE]) + 1)

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0' ,'0  Much Better', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----2
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', '1', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----3
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', '2', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----4
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', '3', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----5
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', '4', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----6
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', '5  No Change', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----7
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', '6', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----8
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', '7', 8, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----9
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '8', '8', 9, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----10
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '9', '9', 10, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
----11
SET @choice = @choice + 1 

INSERT INTO [V5_Registry].[dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '10', '10  Much Worse', 11, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

/*
SELECT * FROM [V5_Registry].[dbo].STD_SURVEY_TYPE
SELECT * FROM [V5_Registry].[dbo].STD_QUESTION
SELECT * FROM [V5_Registry].[dbo].STD_QUESTION_CHOICE 
*/
END

END